<?php
require_once "auth.php"; require_login(); require_active();
header('Content-Type: application/json; charset=utf-8');

$userId=(int)$_SESSION['user']['id'];

if (!isset($_FILES['file'])) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'No file uploaded']);
  exit;
}

$tmp=$_FILES['file']['tmp_name'];
$origName=$_FILES['file']['name'] ?? 'capture.jpg';
$mime=$_FILES['file']['type'] ?? 'image/jpeg';

$stmt=$db->prepare("SELECT * FROM fotoyu_settings WHERE user_id=?");
$stmt->execute([$userId]);
$cfg=$stmt->fetch(PDO::FETCH_ASSOC);

if (!$cfg || empty(trim($cfg['api_url'] ?? ''))) {
  http_response_code(400);
  echo json_encode(['ok'=>false,'error'=>'Fotoyu belum diset. Buka menu Pengaturan Fotoyu.']);
  exit;
}

$apiUrl=trim($cfg['api_url']);
$authType=$cfg['auth_type'] ?? 'none';
$successContains=trim($cfg['success_contains'] ?? '');

$ch=curl_init();
curl_setopt($ch, CURLOPT_URL, $apiUrl);
curl_setopt($ch, CURLOPT_POST, true);
curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
curl_setopt($ch, CURLOPT_TIMEOUT, 45);
curl_setopt($ch, CURLOPT_FOLLOWLOCATION, true);

$headers=['Accept: */*'];

if ($authType==='bearer') {
  $token=trim($cfg['bearer_token'] ?? '');
  if ($token!=='') $headers[]='Authorization: Bearer '.$token;
} elseif ($authType==='basic') {
  curl_setopt($ch, CURLOPT_USERPWD, ($cfg['basic_username'] ?? '').':'.($cfg['basic_password'] ?? ''));
} elseif ($authType==='cookie') {
  $cookie=trim($cfg['cookie_header'] ?? '');
  if ($cookie!=='') $headers[]='Cookie: '.$cookie;

  $csrfName=trim($cfg['csrf_header_name'] ?? '');
  $csrfToken=trim($cfg['csrf_token'] ?? '');
  if ($csrfName!=='' && $csrfToken!=='') $headers[]=$csrfName.': '.$csrfToken;
}

$cfile=new CURLFile($tmp, $mime, $origName);
$post=[
  'file'=>$cfile,
  'filename'=>$origName,
  'source'=>'cam_app',
  'user'=>$_SESSION['user']['username']
];
curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);
curl_setopt($ch, CURLOPT_POSTFIELDS, $post);

$resp=curl_exec($ch);
$errno=curl_errno($ch);
$err=curl_error($ch);
$http=curl_getinfo($ch, CURLINFO_HTTP_CODE);
$ctype=curl_getinfo($ch, CURLINFO_CONTENT_TYPE);
curl_close($ch);

if ($errno) {
  http_response_code(502);
  echo json_encode(['ok'=>false,'error'=>'cURL error: '.$err]);
  exit;
}

// Detect "fake success": HTML response often indicates redirect/login page.
$isHtml = is_string($ctype) && stripos($ctype, 'text/html') !== false;
$looksHtml = is_string($resp) && preg_match('/^\s*<!doctype\s+html|^\s*<html/i', $resp);

$ok = ($http >= 200 && $http < 300);

if ($ok && ($isHtml || $looksHtml) && $successContains==='') {
  // If user didn't set success keyword and we got HTML, treat as suspicious/fail.
  $ok = false;
  $reason = "Response HTML (kemungkinan redirect/login). Set 'Success Contains' atau gunakan mode Cookie/CSRF.";
} else {
  $reason = "";
}

if ($ok && $successContains!=='') {
  if (strpos($resp, $successContains) === false) {
    $ok = false;
    $reason = "Success marker tidak ditemukan di response.";
  }
}

echo json_encode([
  'ok'=>$ok,
  'http'=>$http,
  'content_type'=>$ctype,
  'reason'=>$reason,
  'response'=>substr((string)$resp, 0, 3000) // limit for debugging
]);
