<?php
session_start();

$dbFile = __DIR__ . "/data/database.db";

try {
    $db = new PDO("sqlite:" . $dbFile);
    $db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

    $db->exec("CREATE TABLE IF NOT EXISTS users (
        id INTEGER PRIMARY KEY AUTOINCREMENT,
        username TEXT UNIQUE,
        email TEXT UNIQUE,
        password TEXT,
        role TEXT DEFAULT 'user',
        is_active INTEGER DEFAULT 0
    )");

    // Fotoyu settings
    $db->exec("CREATE TABLE IF NOT EXISTS fotoyu_settings (
        user_id INTEGER PRIMARY KEY,
        api_url TEXT,
        auth_type TEXT DEFAULT 'none', -- none|bearer|basic|cookie
        bearer_token TEXT,
        basic_username TEXT,
        basic_password TEXT,
        cookie_header TEXT,
        csrf_header_name TEXT,
        csrf_token TEXT,
        success_contains TEXT,
        created_at TEXT,
        updated_at TEXT
    )");

    $count = $db->query("SELECT COUNT(*) FROM users WHERE role='admin'")->fetchColumn();
    if ($count == 0) {
        $pass = password_hash("admin123", PASSWORD_DEFAULT);
        $stmt = $db->prepare("INSERT INTO users (username,email,password,role,is_active) VALUES (?,?,?,?,?)");
        $stmt->execute(['admin','admin@example.com',$pass,'admin',1]);
    }
} catch (Exception $e) {
    http_response_code(500);
    echo "<h3>Server Error</h3>";
    echo "DB error: " . htmlspecialchars($e->getMessage());
    exit;
}
?>
